/*
 * Decompiled with CFR 0.152.
 */
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.PDFPageable;

public class PrinterManager {
    public static PrintService[] printServices;

    PrinterManager() {
    }

    public static String[] getPrinters() {
        printServices = PrintServiceLookup.lookupPrintServices(null, null);
        String[] arr = new String[printServices.length];
        for (int i = 0; i < printServices.length; ++i) {
            arr[i] = printServices[i].getName();
        }
        return arr;
    }

    public static boolean print(String filename, int printer) throws Exception {
        File file = new File(filename);
        try {
            PDDocument document = PDDocument.load(file);
            PrintService ps = printer >= 0 ? printServices[printer] : PrintServiceLookup.lookupDefaultPrintService();
            System.out.println("Printing to " + ps);
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPageable(new PDFPageable(document));
            job.setPrintService(ps);
            job.print();
            document.close();
            return true;
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
            return false;
        }
    }
}

