/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class MKAssist {
    private static final String HOST = "techdumpprod.makor-erp.com";
    public static String LOG_FILE;
    public static String ERROR_FILE;
    public static String MAKOR_USERNAME;
    public static String MAKOR_PASSWORD;
    public static String DOWNLOAD_DIRECTORY;
    public static HTTP http;
    public static List<String> cookies;

    public static void main(String[] args) {
        Listener listener;
        try {
            listener = new Listener(9090);
            PrinterManager printer = new PrinterManager();
            if (args.length <= 0) {
                MKAssist.log("Usage: java -jar TDNotifier.jar <config_file>");
                return;
            }
            String config_file = args[0];
            MKAssist.log("Loading config from " + config_file);
            MKAssist.init(config_file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        while (true) {
            try {
                while (true) {
                    Request request;
                    if ((request = listener.getRequest()) != null) {
                        String OrderID;
                        if (request.path.charAt(1) == 'A') {
                            OrderID = request.path.replaceAll("[^0-9]", "");
                            listener.setResponse(MKAssist.getShippingAddress(OrderID), 200, "text/html");
                        } else if (request.path.charAt(1) == 'V') {
                            listener.setResponse("1.6", 200, "text/plain");
                        } else {
                            OrderID = request.path.replaceAll("[^0-9]", "");
                            MKAssist.getPDF(OrderID);
                            PrinterManager.print(DOWNLOAD_DIRECTORY + "/" + OrderID + ".pdf", -1);
                            listener.setResponse("OK", 200, "text/plain");
                            Thread.sleep(1000L);
                        }
                    }
                    Thread.sleep(10L);
                }
            }
            catch (Exception e) {
                listener.setResponse("ERROR", 500, "text/plain");
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void login() throws Exception {
        StringBuilder viewState = new StringBuilder("");
        StringBuilder viewStateGenerator = new StringBuilder("");
        HTTP.sendGET(HOST, "/Login.aspx", cookies, viewState, viewStateGenerator);
        String postParams = "ctl00_RadScriptManager1_TSM=%3B%3BAjaxControlToolkit%2C+Version%3D4.1.60623.0%2C+Culture%3Dneutral%2C+PublicKeyToken%3D28f01b0e84b6d53e%3Aen-US%3A187c1d17-2715-476f-9eeb-4fd46e2849ea%3Aea597d4b%3Ab25378d2%3BTelerik.Web.UI%2C+Version%3D2014.3.1024.40%2C+Culture%3Dneutral%2C+PublicKeyToken%3D121fae78165ba3d4%3Aen-US%3A6787bbbd-e7bc-4076-9645-eb04b617eea2%3A16e4e7cd%3Aed16cbdc%3A874f8ea2%3Af7645509%3A24ee1bba%3Af46195d3%3A92fe8ea0%3Afa31b949%3Ac128760b%3A19620875%3A490a9d4e%3Abd8f85e4&__EVENTTARGET=&__EVENTARGUMENT=&__VIEWSTATE=" + viewState.toString() + "&__VIEWSTATEGENERATOR=" + viewStateGenerator.toString() + "&ctl00_winLocation_ClientState=&ctl00_winLocationConfirmation_ClientState=&ctl00_RadWindowManager1_ClientState=&ctl00%24ContentPlaceHolder1%24Login%24UserName=" + MAKOR_USERNAME + "&ctl00%24ContentPlaceHolder1%24Login%24Password=" + MAKOR_PASSWORD + "&ctl00%24ContentPlaceHolder1%24Login%24LoginButton=LOG+IN";
        HTTP.sendPOST(HOST, "/Login.aspx", cookies, postParams, viewState, viewStateGenerator);
    }

    public static String getShippingAddress(String OrderID) throws Exception {
        StringBuilder viewState = new StringBuilder("");
        StringBuilder viewStateGenerator = new StringBuilder("");
        HTTP.sendGET(HOST, "/ReportViewer.aspx?Report=BulkResalePickList&Parameters=OrderID:" + OrderID, cookies, viewState, viewStateGenerator);
        String postParams = "__EVENTTARGET=ReportViewer1%24ctl09%24Reserved_AsyncLoadTarget&__EVENTARGUMENT=&__VIEWSTATE=" + viewState + "&__VIEWSTATEGENERATOR=" + viewStateGenerator + "&ReportViewer1%24ctl03%24ctl00=&ReportViewer1%24ctl03%24ctl01=&ReportViewer1%24ctl10=ltr&ReportViewer1%24ctl11=standards&ReportViewer1%24AsyncWait%24HiddenCancelField=False&ReportViewer1%24ctl04%24ctl03%24txtValue=" + OrderID + "&ReportViewer1%24ToggleParam%24store=&ReportViewer1%24ToggleParam%24collapse=false&ReportViewer1%24ctl05%24ctl00%24CurrentPage=&ReportViewer1%24ctl05%24ctl03%24ctl00=&ReportViewer1%24ctl08%24ClientClickedId=&ReportViewer1%24ctl07%24store=&ReportViewer1%24ctl07%24collapse=false&ReportViewer1%24ctl09%24VisibilityState%24ctl00=None&ReportViewer1%24ctl09%24ScrollPosition=&ReportViewer1%24ctl09%24ReportControl%24ctl02=&ReportViewer1%24ctl09%24ReportControl%24ctl03=&ReportViewer1%24ctl09%24ReportControl%24ctl04=100&__ASYNCPOST=true&";
        String content = HTTP.sendPOST(HOST, "/ReportViewer.aspx?Report=BulkResalePickList&Parameters=OrderID:" + OrderID, cookies, postParams, viewState, viewStateGenerator);
        Document doc = Jsoup.parse(MKAssist.extractFromPSV("ReportViewer1_ctl09_ReportArea", content));
        Elements elements = doc.body().select("DIV");
        String address = elements.get(25).html();
        System.out.println(address);
        return address;
    }

    public static String extractFromPSV(String key, String content) {
        String[] data = content.split("\\|");
        String value = "";
        for (int i = 0; i < data.length; ++i) {
            if (!data[i].equals(key)) continue;
            int ii = i + 1;
            while (!data[ii].equals("0")) {
                value = value + data[ii];
                ++ii;
            }
            return value;
        }
        return "";
    }

    public static void getPDF(String OrderID) throws Exception {
        StringBuilder viewState = new StringBuilder("");
        StringBuilder viewStateGenerator = new StringBuilder("");
        String content = HTTP.sendGET(HOST, "/ReportViewer.aspx?Report=BulkResalePickList&Parameters=OrderID:" + OrderID, cookies, viewState, viewStateGenerator);
        String file = "/Reserved.ReportViewerWebControl.axd?" + MKAssist.extractParam("ReportSession", content) + "&Culture=1033&CultureOverrides=True&UICulture=1033&UICultureOverrides=True&ReportStack=1&" + MKAssist.extractParam("ControlID", content) + "&OpType=Export&FileName=BulkResalePickList&ContentDisposition=OnlyHtmlInline&Format=PDF";
        HTTP.GET_download(HOST, file, cookies, "", DOWNLOAD_DIRECTORY + "/" + OrderID + ".pdf");
    }

    public static String extractParam(String param, String content) {
        Pattern pattern = Pattern.compile(param + "=(.*?)\\\\u0026");
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(0).replaceAll("\\\\u0026", "");
        }
        return "";
    }

    public static void init(String configFile) throws Exception {
        FileInputStream configStream = new FileInputStream(new File(configFile));
        String configContent = "";
        byte[] buffer = new byte[64];
        while (((InputStream)configStream).read(buffer) != -1) {
            configContent = configContent + new String(buffer);
        }
        JSONObject config = new JSONObject(configContent);
        LOG_FILE = config.getString("LOG_FILE");
        ERROR_FILE = config.getString("ERROR_FILE");
        MAKOR_USERNAME = config.getString("MAKOR_USERNAME");
        MAKOR_PASSWORD = config.getString("MAKOR_PASSWORD");
        DOWNLOAD_DIRECTORY = config.getString("DOWNLOAD_DIRECTORY");
        MKAssist.login();
    }

    public static void writeToFile(String str, String file) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
            writer.append(str);
            writer.append('\n');
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void log(String message) {
        System.out.println(MKAssist.timeStamp() + ": " + message);
    }

    public static String timeStamp() {
        String pattern = "MM-dd-yy hh:mm:ss a";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        String time = simpleDateFormat.format(new Date());
        return time;
    }

    static {
        http = new HTTP();
        cookies = new ArrayList<String>();
    }
}

