/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class HWAssist {
    private static final String[] tests = new String[]{"Keyboard", "Mouse", "Internal Speakers", "External Speakers", "Webcam", "Wi-Fi", "Battery", "Stress", "USB", "Wipe", "Optical Drive", "Hard Drive", "RTC"};
    private static DriveHandler drive;
    public static String SRV_PATH;
    public static String LOGGING_DATABASE_ID;
    public static String LOGGING_DATABASE_RANGE;
    public static JSONArray LOGGING_CUSTOM_COLUMNS;
    public static String MAKOR_API_URL;
    public static JSONArray MAKOR_CUSTOM_FIELDS;
    public static String TOKENS_DIRECTORY_PATH;
    public static int PORT;

    HWAssist() {
    }

    public static void main(String[] args) {
        try {
            if (args.length <= 0) {
                HWAssist.log("Usage: java -jar HWAssist.jar <config_file>");
                return;
            }
            String config_file = args[0];
            HWAssist.log("Loading config from " + config_file);
            HWAssist.init(config_file);
            drive = new DriveHandler("HWAssist", TOKENS_DIRECTORY_PATH);
            Listener listener = new Listener(PORT);
            while (true) {
                Request request;
                if ((request = listener.getRequest()) != null) {
                    System.out.println(request.path);
                    System.out.println(request.content);
                    switch (request.path) {
                        case "/groups.xml": {
                            listener.setResponse(new File(SRV_PATH + "/groups.xml"), 200, "text/xml");
                            break;
                        }
                        case "/custom_fields.xml": {
                            listener.setResponse(new File(SRV_PATH + "/custom_fields.xml"), 200, "text/xml");
                            break;
                        }
                        case "/report": {
                            String report = request.content.replaceAll("[^\\x1F-\\x7F]", "");
                            listener.setResponse("OK", 200, "text/plain");
                            if (!LOGGING_DATABASE_ID.equals("")) {
                                HWAssist.updateLog(report);
                            }
                            if (MAKOR_API_URL.equals("")) break;
                            Makor.uploadSpecs(report, MAKOR_CUSTOM_FIELDS, MAKOR_API_URL);
                            break;
                        }
                        default: {
                            listener.setResponse("404", 404, "text/plain");
                        }
                    }
                }
                Thread.sleep(10L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static void init(String configFile) throws IOException, JSONException {
        FileInputStream configStream = new FileInputStream(new File(configFile));
        String configContent = "";
        byte[] buffer = new byte[64];
        while (((InputStream)configStream).read(buffer) != -1) {
            configContent = configContent + new String(buffer);
        }
        JSONObject config = new JSONObject(configContent);
        SRV_PATH = config.getString("SRV_PATH");
        LOGGING_DATABASE_ID = config.getString("LOGGING_DATABASE_ID");
        LOGGING_DATABASE_RANGE = config.getString("LOGGING_DATABASE_RANGE");
        LOGGING_CUSTOM_COLUMNS = config.getJSONArray("LOGGING_CUSTOM_COLUMNS");
        TOKENS_DIRECTORY_PATH = config.getString("TOKENS_DIRECTORY_PATH");
        MAKOR_API_URL = config.getString("MAKOR_API_URL");
        MAKOR_CUSTOM_FIELDS = config.getJSONArray("MAKOR_CUSTOM_FIELDS");
        PORT = config.getInt("PORT");
    }

    public static String getPath() {
        try {
            return new File(HWAssist.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParent();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Element getDirectChild(Element parent, String name) {
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element) || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static boolean updateLog(String reportStr) {
        try {
            int i;
            int i2;
            Object[] results = new Object[tests.length];
            Document report = HWAssist.StringToXML(reportStr);
            NodeList testNodes = report.getElementsByTagName("test");
            Arrays.fill(results, "N/A");
            ArrayList<List<Object>> values = new ArrayList<List<Object>>();
            values.add(new ArrayList());
            for (i2 = 0; i2 < tests.length; ++i2) {
                ((List)values.get(0)).add("N/A");
            }
            for (i2 = 0; i2 < testNodes.getLength(); ++i2) {
                Node test = testNodes.item(i2);
                if (test.getNodeType() != 1) continue;
                Element eElement = (Element)test;
                ((List)values.get(0)).set(HWAssist.test_name_to_index(eElement.getAttribute("name")), eElement.getElementsByTagName("result").item(0).getTextContent());
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");
            Date date = new Date();
            String today = dateFormat.format(date);
            Node nNode = report.getElementsByTagName("report").item(0);
            Element eElement = (Element)nNode;
            String serial = HWAssist.getDirectChild(eElement, "serial").getTextContent();
            String manufacturer = HWAssist.getDirectChild(eElement, "manufacturer").getTextContent();
            String product = HWAssist.getDirectChild(eElement, "product").getTextContent();
            String CPU = HWAssist.getDirectChild(HWAssist.getDirectChild(eElement, "CPU"), "model").getTextContent();
            String RAM = HWAssist.getDirectChild(HWAssist.getDirectChild(eElement, "RAM"), "size").getTextContent();
            String form_factor = HWAssist.getDirectChild(eElement, "form_factor").getTextContent();
            HashMap<String, String> custom_field_values = new HashMap<String, String>();
            if (eElement.getElementsByTagName("custom_fields").getLength() > 0) {
                NodeList custom_fields = ((Element)eElement.getElementsByTagName("custom_fields").item(0)).getElementsByTagName("field");
                for (int i3 = 0; i3 < custom_fields.getLength(); ++i3) {
                    custom_field_values.put(((Element)custom_fields.item(i3)).getAttribute("name"), custom_fields.item(i3).getTextContent());
                }
            }
            NodeList HDDs = eElement.getElementsByTagName("HDD");
            String driveList = "";
            for (i = 0; i < HDDs.getLength(); ++i) {
                String HDD_capacity = HWAssist.getDirectChild((Element)HDDs.item(i), "capacity").getTextContent();
                String HDD_serial = HWAssist.getDirectChild((Element)HDDs.item(i), "serial").getTextContent();
                driveList = driveList + HDD_capacity + "[" + HDD_serial + "], ";
            }
            ((List)values.get(0)).add(0, driveList);
            ((List)values.get(0)).add(0, RAM);
            ((List)values.get(0)).add(0, CPU);
            ((List)values.get(0)).add(0, form_factor);
            ((List)values.get(0)).add(0, product);
            ((List)values.get(0)).add(0, manufacturer);
            ((List)values.get(0)).add(0, serial);
            for (i = LOGGING_CUSTOM_COLUMNS.length() - 1; i >= 0; --i) {
                String name = LOGGING_CUSTOM_COLUMNS.get(i).toString();
                if (custom_field_values.containsKey(name)) {
                    ((List)values.get(0)).add(0, custom_field_values.get(name));
                    continue;
                }
                ((List)values.get(0)).add(0, "");
            }
            ((List)values.get(0)).add(0, today);
            DriveHandler.updateSpreadsheet(values, LOGGING_DATABASE_ID, LOGGING_DATABASE_RANGE);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static int test_name_to_index(String name) {
        for (int i = 0; i < tests.length; ++i) {
            if (!name.equals(tests[i])) continue;
            return i;
        }
        return -1;
    }

    private static Document StringToXML(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void log(String message) {
        System.out.println(HWAssist.timeStamp("MM-dd-yy hh:mm:ss a") + ": " + message);
    }

    public static String timeStamp(String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        String time = simpleDateFormat.format(new Date());
        return time;
    }
}

