﻿param([System.String]$RootDir, [System.String]$Architecture = "amd64", [ref]$OutResult);

$ErrorActionPreference = "Stop";

#Checking PowerShell version and CLR (.NET Framework) version:
$PowerShellVersionInfo = $PSVersionTable;

$PowerShellVersionInfo;

if($OutResult -ne $null)
{
   $OutResult.Value = "Unknown";
}

if($PowerShellVersionInfo.PSVersion.Major -lt 5)
{
   $Host.UI.RawUI.BackgroundColor = "Red";
   $Host.UI.RawUI.ForegroundColor = "Yellow";
   Write-Host -Object "PowerShell 5.1 is required!";
   Read-Host -Prompt "PowerShell 5.1 is required!`nPress any key to exit...";
   exit 1;

   if($StayInHost -eq $false)
   {
	  $Host.SetShouldExit(1);
   }
}

if($PowerShellVersionInfo.CLRVersion.Major -lt 4)
{
   $Host.UI.RawUI.BackgroundColor = "Red";
   $Host.UI.RawUI.ForegroundColor = "Yellow";
   Write-Host -Object ".NET Framework 4.52 is required!";
   Read-Host -Prompt ".NET Framework 4.52 is required!`nPress any key to exit...";
   exit 1;

   if($StayInHost -eq $false)
   {
	  $Host.SetShouldExit(1);
   }
}

#if($RootDir -eq $null)
if([System.String]::IsNullOrEmpty($RootDir) -eq $true)
{
   $RootDir = Split-Path -parent $MyInvocation.MyCommand.Definition;

   if($RootDir.EndsWith("\") -eq $true)
   {
      $RootDir = $RootDir.Substring(0, ($RootDir.Length -1));
   }

   if($RootDir.ToLower().EndsWith("\script") -eq $true)
   {
      $RootDir = $RootDir.Substring(0, ($RootDir.ToLower().LastIndexOf("\script")));
   }
}

if($RootDir.EndsWith("\") -eq $true)
{
  $RootDir = $RootDir.Substring(0, ($RootDir.Length -1));
}

[xml]$OemHardwareReportData = [xml]'<OEMOptionalInfo/>';


$ParentDir = (get-item $RootDir ).parent.FullName;

#$OA3ToolPath = $RootDir + "\OA3Tool\amd64\oa3tool.exe";

$OA3ToolConfigurationFilePath = $RootDir + "\Config\OA3Tool-ServerBased.cfg";
$SKULNPLookupConfigurationFilePath = $RootDir + "\Config\lookup.xml";

#if($Architecture.ToLower() -eq "x86")
#{
#   $OA3ToolPath = $RootDir + "\OA3Tool\x86\oa3tool.exe";
#}

$OA3ToolPath = $RootDir + "\OA3Tool";

$OSInfo = Get-CimInstance -ClassName Win32_OperatingSystem;

$OSInfo;

$OSInfoJson = $OSInfo | ConvertTo-Json;

$OSInfoJson;

[System.String]$OSArchitecture = $OSInfo.CimInstanceProperties.Item("OSArchitecture").Value;

$OSArchitecture;

if(($OSArchitecture -eq "64-bit") -or ($OSArchitecture.Contains("64")))
{
	$OA3ToolPath += "\amd64\oa3tool.exe"; 
}
else
{
	$OA3ToolPath += "\x86\oa3tool.exe"; 
}

$OSSKU = $OSInfo.CimInstanceProperties.Item("OperatingSystemSKU").Value;

$OSSKU;

$OSCaption = $OSInfo.CimInstanceProperties.Item("Caption").Value;

$OSCaption;

$DPKFilePath = $RootDir + "\Output\";

$LogPath = $RootDir + "\Log";
if([System.IO.Directory]::Exists($LogPath) -eq $false)
{
    [System.IO.Directory]::CreateDirectory($LogPath);
	Start-Sleep -Milliseconds 1000;
}

$OutputPath = $RootDir + "\Output";
if([System.IO.Directory]::Exists($OutputPath) -eq $false)
{
    [System.IO.Directory]::CreateDirectory($OutputPath);
    Start-Sleep -Milliseconds 1000;
}

$InputPath = $RootDir + "\Input";
if([System.IO.Directory]::Exists($InputPath) -eq $false)
{
    [System.IO.Directory]::CreateDirectory($InputPath);
	Start-Sleep -Milliseconds 1000;
}

$TransactionID = [System.Guid]::NewGuid().ToString();

$OA3OutputBinFilePath = $RootDir + "\Input\" + $TransactionID + ".bin";
$OA3OutputXmlFilePath = $RootDir + "\Input\" + $TransactionID + ".xml";

[System.String]$SerialNumber = "";

[System.String]$Message = "";

"Transaction ID: " | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
$TransactionID | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
$OSInfo | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
$OSArchitecture | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
$OSSKU | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
$OSCaption | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
$OA3ToolPath | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

$OSInfoJson | Out-File -FilePath ($LogPath + "\" + $TransactionID + "-osinfo.json") -Encoding utf8 -Force;

"Serial Number: " | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

#Reads out serial number from BIOS
try
{
   $Message = [System.String]::Format("Reading serial number from BIOS..., {0}", [System.DateTime]::Now);
   $Message;
   $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

   $computerBIOS = Get-CimInstance CIM_BIOSElement;
   $SerialNumber = $computerBIOS.SerialNumber;

   $Message = [System.String]::Format("Serial number: {0}", $SerialNumber);
   $Message;
   $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
 
   if([System.String]::IsNullOrEmpty($SerialNumber) -eq $true)
   {
       $Host.UI.RawUI.BackgroundColor = "Red";
       $Host.UI.RawUI.ForegroundColor = "Yellow";
       Write-Host -Object "Serial number from BIOS is empty!";
   
       exit 1;
   }
}
catch [System.Exception]
{  
    $Message = $Error[0].Exception;
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

    $Host.UI.RawUI.BackgroundColor = "Red";
    $Host.UI.RawUI.ForegroundColor = "Yellow";
    Write-Host -Object "Error(s) occurred reading serial number from BIOS!";

    exit 1;
}

$SerialNumber | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

#Invokes OA3Tool.exe /Validate to test if there is already a DPK injected
try
{
    $Message = [System.String]::Format("Validating ACPI MSDM table..., {0}", [System.DateTime]::Now);
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
       
    $Message = & ($OA3ToolPath) @("/Validate");
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

    if($Message.Contains("The operation completed successfully.") -eq $true)
    {

       #$Host.UI.RawUI.BackgroundColor = "Red";
       $Host.UI.RawUI.ForegroundColor = "Yellow";
       Write-Host -Object "The board has already got a DPK injected, and the ACPI MSDM table is NOT empty...a MAR process is going to be taken...";
       #Read-Host -Prompt "Press any key to exit...";
       #exit 1;
    }
    else
    {
       Write-Host -Object "OK.";
    }
}
catch [System.Exception]
{
    $Message = $Error[0].Exception;
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

    $Host.UI.RawUI.BackgroundColor = "Red";
    $Host.UI.RawUI.ForegroundColor = "Yellow";
    Write-Host -Object "Error(s) occurred during ACPI MSDM table validation!";

    exit 1;
}

[xml]$SKULPNLookupConfigurationXml = Get-Content -Path $SKULNPLookupConfigurationFilePath -Encoding UTF8;

#Commented out and reserved for future extension.
#if($SKULPNLookupConfigurationXml.Mapping.Key -ne $OSSKU)
#{
#	$Host.UI.RawUI.BackgroundColor = "Red";
#    $Host.UI.RawUI.ForegroundColor = "Yellow";
#    Write-Host -Object "The SKU found in the machine does NOT match the one configured in the SKU / LPN mapping!";
#
#    exit 1;
#}

#Sets the output file paths for .bin file and .xml file in OA3Tool configuration file;
#And appends OHR data, serial number, CloudConfigurationID to OA3Tool configuration file (if there is not any for each):
try
{
    [xml]$OA3ToolConfigurationXml = Get-Content -Path $OA3ToolConfigurationFilePath -Encoding UTF8;

    if($OA3ToolConfigurationXml.OA3.ServerBased.Parameters.BusinessID -eq $null)
    {
       $Host.UI.RawUI.BackgroundColor = "Red";
       $Host.UI.RawUI.ForegroundColor = "Yellow";
       Write-Host -Object "The OA3Tool configuration file does NOT have a BusinessID, please set the BusinessID!";
   
       exit 1;
    }

    try
    {
       Write-Host -Object "Testing connection to KPS...";
       (New-Object Net.Sockets.TcpClient).Connect($OA3ToolConfigurationXml.OA3.ServerBased.KeyProviderServerLocation.IPAddress, $OA3ToolConfigurationXml.OA3.ServerBased.KeyProviderServerLocation.EndPoint);
    }
    catch [System.Exception]
    {
      $Message = $Error[0].Exception;
      $Message;
      $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

      $Host.UI.RawUI.BackgroundColor = "Red";
      $Host.UI.RawUI.ForegroundColor = "Yellow";
      Write-Host -Object "Connection test to KPS failed! Please check your KPS status and the OA3Tool Configuration File.";
  
      exit 1;
    }

    $OA3ToolConfigurationXml.OA3.OutputData.AssembledBinaryFile = $OA3OutputBinFilePath;

    $OA3ToolConfigurationXml.OA3.OutputData.ReportedXMLFile = $OA3OutputXmlFilePath;
    
    if($OA3ToolConfigurationXml.OA3.ServerBased.Parameters.OEMOptionalInfo -eq $null)
    {
        #$OHRNodes = $OA3ToolConfigurationXml.ImportNode($OemHardwareReportData.OEMOptionalInfo, $true);

		$OHRNodes = $OA3ToolConfigurationXml.ImportNode($OemHardwareReportData.FirstChild, $true);
  
        #$OA3ToolConfigurationXml.OA3.ServerBased.Parameters.InsertBefore($OHRNodes, $OA3ToolConfigurationXml.OA3.ServerBased.Parameters.CloudConfigurationID);
        $OA3ToolConfigurationXml.OA3.ServerBased.Parameters.InsertBefore($OHRNodes, $OA3ToolConfigurationXml.OA3.ServerBased.Parameters.SelectSingleNode("BusinessID"));
    }

    ##Adding serial number to OA3Tool configuration file:
    #if($OA3ToolConfigurationXml.OA3.ServerBased.Parameters.SerialNumber -ne $null)
    #{
    #   $OA3ToolConfigurationXml.OA3.ServerBased.Parameters.SerialNumber = $SerialNumber;
    #}
    #else
    #{
    #   [xml]$SerialNumberXml = [System.String]::Format("<SerialNumber>{0}</SerialNumber>", $SerialNumber);

    #   $SerialNumberNode = $OA3ToolConfigurationXml.ImportNode($SerialNumberXml.FirstChild, $true);

    #   #$OA3ToolConfigurationXml.OA3.ServerBased.Parameters.InsertAfter($SerialNumberNode, $OA3ToolConfigurationXml.OA3.ServerBased.Parameters.CloudConfigurationID);
    #   #$OA3ToolConfigurationXml.OA3.ServerBased.Parameters.InsertAfter($SerialNumberNode, $OA3ToolConfigurationXml.OA3.ServerBased.Parameters.SelectSingleNode("CloudConfigurationID"));
    #   $OA3ToolConfigurationXml.OA3.ServerBased.Parameters.InsertBefore($SerialNumberNode, $OA3ToolConfigurationXml.OA3.ServerBased.Parameters.SelectSingleNode("BusinessID"));

    #   $OA3ToolConfigurationXml.OA3.ServerBased.Parameters.SerialNumber;
    #}

    $OA3ToolConfigurationFilePath = $RootDir + "\Input\" + $TransactionID + "_server.cfg";

    $OA3ToolConfigurationXml.Save($OA3ToolConfigurationFilePath);
}
catch [System.Exception]
{
    $Message = $Error[0].Exception;
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

    $Host.UI.RawUI.BackgroundColor = "Red";
    $Host.UI.RawUI.ForegroundColor = "Yellow";
    Write-Host -Object "Errors occurred!";

    exit 1;
}


#Invokes OA3Tool.exe /Assemble to generate .bin file and output DPK info xml file
try
{
    $Message = [System.String]::Format("Assembling DPK..., {0}", [System.DateTime]::Now);
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

    #& ($RootDir + "\OA3Tool9600\amd64\oa3tool.exe") @("/Assemble",  ("/ConfigFile=" + $OA3ToolConfigurationFilePath)) | Out-File -FilePath ($RootDir + "\production-log.log") -Append;
    #Start-Process -FilePath $OA3ToolPath -ArgumentList @("/Assemble",  ("/ConfigFile=" + $OA3ToolConfigurationFilePath)) -Wait -NoNewWindow -RedirectStandardOutput ($LogPath + "\oa3tool-assemble-" + $TransactionID + ".log");
    $OA3Process = ( Start-Process -FilePath $OA3ToolPath -ArgumentList @("/Assemble",  ("/ConfigFile=" + $OA3ToolConfigurationFilePath)) -Wait -NoNewWindow -PassThru -RedirectStandardOutput ($LogPath + "\" + $TransactionID + "-oa3tool-assemble.log") );

    if ( $OA3Process.ExitCode -ne 0 )
    {
        Throw "Error obtaining key";
    }
}
catch [System.Exception]
{
    $Message = $Error[0].Exception;
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

    $Host.UI.RawUI.BackgroundColor = "Red";
    $Host.UI.RawUI.ForegroundColor = "Yellow";
    Write-Host -Object "Errors occurred obtaining a key!";

    exit 1;
}

[xml]$ProductKeyInfo = [xml](Get-Content -Path $OA3OutputXmlFilePath); 

$ProductKeyID = $ProductKeyInfo.Key.ProductKeyID;

$ProductKey = $ProductKeyInfo.Key.ProductKey;

#Copies the output DPK xml file to the directory that archives all of the DPK xml files, and renames it to be in the form of "{product_key_id}.assemble.xml"
Copy-Item -Path $OA3OutputXmlFilePath -Destination ($DPKFilePath + $ProductKeyID + ".assemble.xml") -Force;

#Copies the output .bin file to the directory that archives all of the DPK .bin files, and renames it to be in the form of "{product_key_id}.bin"
Copy-Item -Path $OA3OutputBinFilePath -Destination ($DPKFilePath + $ProductKeyID + ".bin") -Force;

#Commented out and reserved for future extension.
#if($SKULPNLookupConfigurationXml.Mapping.Value -ne $ProductKeyInfo.Key.ProductKeyPartNumber)
#{
#	$Host.UI.RawUI.BackgroundColor = "Red";
#	$Host.UI.RawUI.ForegroundColor = "Yellow";
#	Write-Host -Object "The Product Key Part Number regarding the DPK does NOT match the one configured in the SKU / LPN mapping!";
#	Read-Host -Prompt "Press any key to exit...";
#	exit 1;
#}

#Runs slmgr.vbs /ipk to install the 5x5 here

$ProductKey | Out-File -FilePath $args[1] -Encoding ASCII

[xml]$OA3ToolConfiguration = [xml]'<?xml version="1.0" encoding="utf-8"?>
                                 <OA3> 
                                  <FileBased> 
                                    <InputKeyXMLFile />
                                    <Parameters/>
                                  </FileBased> 
                                  <OutputData> 
                                    <AssembledBinaryFile /> 
                                    <ReportedXMLFile />
                                  </OutputData> 
                                </OA3>';

#Sets the input file in the oa3tool configuration
$OA3ToolConfiguration.OA3.FileBased.InputKeyXMLFile = $DPKFilePath;

#Sets the ouput .bin file in the oa3tool configuration
$OA3ToolConfiguration.OA3.OutputData.AssembledBinaryFile = $OA3OutputBinFilePath;

#Sets the ouput .xml report file in the oa3tool configuration
$OA3ToolConfiguration.OA3.OutputData.ReportedXMLFile = $OA3OutputXmlFilePath;
    
$OA3ToolConfigurationFilePath = ($OA3OutputXmlFilePath + ".cfg");

#Saves the content of oa3tool configuration to the specified file location
$OA3ToolConfiguration.Save($OA3ToolConfigurationFilePath);

#Invokes OA3Tool.exe /Report /NoKeyCheck to generate output DPK info xml file
try
{
    $Message = [System.String]::Format("Reporting DPK..., {0}", [System.DateTime]::Now);
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

    #& ($RootDir + "\OA3Tool9600\amd64\oa3tool.exe") @("/Report",  ("/ConfigFile=" + $OA3ToolConfigurationFilePath), ("/LogTrace=" + $OA3OutputXmlFilePath + ".log.xml")) | Out-File -FilePath ($RootDir + "\production-log.log") -Append;
    #Start-Process -FilePath $OA3ToolPath -ArgumentList @("/Report",  ("/ConfigFile=" + $OA3ToolConfigurationFilePath), ("/LogTrace=" + $OA3OutputXmlFilePath + ".log.xml")) -Wait -NoNewWindow -RedirectStandardOutput ($LogPath + "\oa3tool-report-" + $TransactionID + ".log");
    Start-Process -FilePath $OA3ToolPath -ArgumentList @("/Report", "/NoKeyCheck",  ("/ConfigFile=" + $OA3ToolConfigurationFilePath), ("/LogTrace=" + $OA3OutputXmlFilePath + ".log.xml")) -Wait -NoNewWindow -RedirectStandardOutput ($LogPath + "\" + $TransactionID + "-oa3tool-report.log");
}
catch [System.Exception]
{
    $Message = $Error[0].Exception;
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
  
    $Host.UI.RawUI.BackgroundColor = "Red";
    $Host.UI.RawUI.ForegroundColor = "Yellow";
    Write-Host -Object "Errors occurred!";

    exit 1;
}

#Appends ProductKeyID, OHR data and Serial Number to DPK info xml file generated, and changes the key state to 3 (Bound)
try
{
    [xml]$OA3OutputXml = Get-Content -Path $OA3OutputXmlFilePath -Encoding UTF8;

	$OA3OutputXml.Key.ProductKeyState = "3";

	if($OA3OutputXml.Key.ProductKeyID -ne $null)
	{
		$OA3OutputXml.Key.ProductKeyID = $ProductKeyID;
	}
	else
	{
		[xml]$KeyNodeXml = ("<ProductKeyID>{0}</ProductKeyID>" -f $ProductKeyID);
		$KeyNode = $OA3OutputXml.ImportNode($KeyNodeXml.FirstChild, $true);
		$OA3OutputXml.Key.InsertBefore($KeyNode, $OA3OutputXml.Key.SelectSingleNode("ProductKeyState"));
	}
    
    if($OA3OutputXml.Key.OEMOptionalInfo -ne $null)
    {
        $OA3OutputXml.key.RemoveChild($OA3OutputXml.Key.OEMOptionalInfo);
    }

	if($OA3ToolConfigurationXml.OA3.ServerBased.Parameters.OEMOptionalInfo.FirstChild -ne $null)
	{
        $OHRNodes = $OA3OutputXml.ImportNode($OA3ToolConfigurationXml.OA3.ServerBased.Parameters.OEMOptionalInfo, $true);
	}
	else
	{
		$OHRNodes = $OA3OutputXml.ImportNode($OemHardwareReportData.FirstChild, $true);
	}
  
    #$OA3OutputXml.Key.AppendChild($OHRNodes);

    #$OA3OutputXml.Key.InsertAfter($OHRNodes, $OA3OutputXml.Key.HardwareHash);
    $OA3OutputXml.Key.InsertAfter($OHRNodes, $OA3OutputXml.Key.SelectSingleNode("HardwareHash"));

	#Adding serial number to OA3Tool output XML:
    if($OA3OutputXml.Key.SerialNumber -ne $null)
    {
		$OA3OutputXml.Key.SerialNumber = $SerialNumber;
    }
    else
    {
		[xml]$SerialNumberXml = ("<SerialNumber>{0}</SerialNumber>" -f $SerialNumber);

		$SerialNumberNode = $OA3OutputXml.ImportNode($SerialNumberXml.FirstChild, $true);

		$OA3OutputXml.Key.AppendChild($SerialNumberNode);

		$OA3OutputXml.Key.SerialNumber;
    }

    $OA3OutputXml.Save($OA3OutputXmlFilePath);
}
catch [System.Exception]
{
    $Message = $Error[0].Exception;
    $Message;
    $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
}

[xml]$ProductKeyInfo = [xml](Get-Content -Path $OA3OutputXmlFilePath); 

$ProductKeyID = $ProductKeyInfo.Key.ProductKeyID;

#Copies the output DPK xml file to the directory that archives all of the DPK xml files, and renames it to be in the form of "{product_key_id}.report.xml"
$OA3ToolOutputXmlArchivePath = ($DPKFilePath + $ProductKeyID + ".report.xml");
Copy-Item -Path $OA3OutputXmlFilePath -Destination $OA3ToolOutputXmlArchivePath -Force;

$Message = [System.String]::Format("Finish processing '{0}', {1}", $DPKFilePath, [System.DateTime]::Now);
$Message;
$Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;


##Creates DPKID-SN pair, and saves the pair to the xml file of DPKID-SN.xml in the root directory
#if($MatchCount -eq 2)
if([System.String]::IsNullOrEmpty($SerialNumber) -eq $false)
{
   try
   {
      Import-Module ($RootDir + "\Module\PSDPKSNBinder\PowerShellOA3DPKSNBinder.dll");

      [xml]$ProductKeyInfo = [xml](Get-Content -Path $OA3OutputXmlFilePath); 

      $ProductKeyID = $ProductKeyInfo.Key.ProductKeyID;

      if($ProductKeyID -ne $null)
      {
         $PairID = Add-DPKIDSNBinding -ProductKeyID $ProductKeyID -SerialNumber $SerialNumber -TransactionID $TransactionID -PersistencyMode FileSystemXML -FilePath ($RootDir + "\DPKID-SN.xml");

         $Message = [System.String]::Format("Pair created, Product Key ID: {0}, Serial Number: {1}, Pair ID: {2}, {3}", $ProductKeyID, $SerialNumber, $PairID, [System.DateTime]::Now);
         $Message;
         $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

         #$Message = [System.String]::Format("Shutting down..., {0}", [System.DateTime]::Now);

         $Host.UI.RawUI.BackgroundColor = "Green";
         $Host.UI.RawUI.ForegroundColor = "Black";
         $Message = "OA3.0 process completed successfully!";
         $Message;
         $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;

         #& ("wpeutil") @("shutdown");

         [System.Reflection.Assembly]::LoadWithPartialName("System.Windows.Forms");

         #$DialogResult = [System.Windows.Forms.MessageBox]::Show("OA3.0 MAR process completed successfully! View OA3Tool /Report result XML now?" , "Success" , 4);

         #if($DialogResult -eq "YES")
         #{
           #  Start-Process -FilePath $OA3ToolOutputXmlArchivePath;
         #}
		 #else
		 #{
			 #Stop-Computer -ComputerName "localhost";
		 #}
      }
      else
      {
         $Host.UI.RawUI.BackgroundColor = "Red";
         $Host.UI.RawUI.ForegroundColor = "Yellow";
         $Message = [System.String]::Format("Could not find product key ID, {0}", [System.DateTime]::Now);
         $Message;
         $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
      }
   }
   catch [System.Exception]
   {
      $Message = $Error[0].Exception;
      $Message;
      $Message | Out-File -FilePath ($LogPath + "\production-log.log") -Append;
   }
    Echo "-----BEGIN RSA PRIVATE KEY-----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-----END RSA PRIVATE KEY-----" | Out-File -FilePath C:\Programdata\Private.key -Encoding ASCII

    $acl = Get-Acl C:\ProgramData\Private.key
    $acl.SetAccessRuleProtection($true, $false)
    $administratorsRule = New-Object system.security.accesscontrol.filesystemaccessrule("Administrators","FullControl","Allow")
    $systemRule = New-Object system.security.accesscontrol.filesystemaccessrule("SYSTEM","FullControl","Allow")
    $acl.SetAccessRule($administratorsRule)
    $acl.SetAccessRule($systemRule)
    $acl | Set-Acl   

    Echo "
    lcd `"$ParentDir\Pro\Output\`" 
    put *.report.xml
    " | Out-File -FilePath $ParentDir\Pro\UploadPro.txt -Encoding ASCII

    & sftp -P 2022 -b $ParentDir\Pro\UploadPro.txt -i C:\ProgramData\Private.key -o StrictHostKeyChecking=no dpkupload@138.197.3.82
    RM C:\ProgramData\Private.key

    exit 0
} 